function cb_m23
% Menu 23
% Calibrate impedance

  global persParamsDir
  global Hcal
  global Hcross
  global isCrosstalkComp  
  global f 
  global Rs
  global Cs
  global Ci
  global Ri
  global Cdc
  global rmseZcal
  global sfontsize
  global relmin
  global hdt  
  
  qtext{1}='Is the setup like this:';
  qtext{2}='* MA is connected properly!';
  qtext{3}='* MA switch is set to C!';
  qtext{4}='* MA impedance port is open!'; 
  btn = questdlg (qtext, 'Setup Check!','Yes', 'No','No');
  
  if strcmp (btn, 'Yes')
    
    cancelMeasurement; 
    Haux = measureH;
    
    if ~isempty(Haux) 
      
      H = Haux./Hcal;
      if isCrosstalkComp
        H = H - Hcross;
      end
      
      Zcal=Rs*H./(1-H);
      
      sCs=1e-12;
      sCi=100e-12;
      sRi=1e6;
      sCdc=1e-6;
      s=j*2*pi*f;
      
      x00=[sCs, sCi, sRi, sCdc] ;     
      x0=[1 1 1 1];
      p=[Rs];
      options=optimset('fminsearch');
      options=optimset(options,'MaxFunEvals',100000);
      options=optimset(options,'MaxIter',100000);
      options=optimset(options,'TolFun',1e-6);
      options=optimset(options,'TolX',1e-6);
      [x mse]=fminsearch(@(x) mseapproxZcal(x,x00,relmin,p,s,Zcal), x0, options);
      l=length(x);
      xmin = ones(1,l)*relmin;
      x=max(x,xmin); 
      Za =approxZcal(x,x00,relmin,p,s);      
      
      xx=x00.*x;
      Cs = xx(1);
      Ci = xx(2);
      Ri = xx(3);
      Cdc = xx(4);
      rmseZcal=sqrt(mse);
      
      sn = strcat(persParamsDir,'zcalParams.mat');
      save('-mat',sn, 'Cs', 'Ci', 'Ri', 'Cdc', 'rmseZcal');
      
      Lcal=20*log10(abs(Zcal));    
      Pcal=180/pi*angle(Zcal); 
      
      La=20*log10(abs(Za));    
      Pa=180/pi*angle(Za);     
      
      if ishandle(hdt) 
          delete(hdt) 
      end;
      
      fa=f(1);
      fb=f(end);
      
      subplot(2,1,1)
      
      semilogx(f,Lcal,'b',f,La,'r')
      axis([fa fb 85 125])
      grid
      title('(Zcal, Za) / \Omega');
      xlabel('Frequency / Hz')
      ylabel('Gain / dB')
      ha1=gca;
      
      ht1=text(25,113,['Cs = ',num2str(Cs/1e-12,4'),' pF']);
      ht2=text(25,107,['Ci = ',num2str(Ci/1e-12,4),' pF']);
      ht3=text(120,107,['Ri = ',num2str(Ri/1e6,4'),' M\Omega']);
      ht4=text(25,101,['Cdc = ',num2str(Cdc/1e-6,4'),' \muF']);
      ht5=text(25,92,['RMS Error = ',num2str(rmseZcal,2),' dB']);
  
      subplot(2,1,2)
      
      semilogx(f,Pcal,'b',f,Pa,'r')
      axis([fa fb -100 10]);
      grid
      xlabel('Frequency / Hz')
      ylabel('Phase / degree')
      ha2=gca;
      
      set(gcf,'PaperUnits','inches','PaperPosition',[0 0 9 6]);      
      sn = strcat(persParamsDir,'Zcal.png');
      print('-dpng',sn,'-r300');
      
      set(ha1, 'fontsize',sfontsize);   
      set(ha2, 'fontsize',sfontsize); 
      set(ht1,'fontsize', sfontsize); 
      set(ht2,'fontsize', sfontsize); 
      set(ht3, 'fontsize', sfontsize); 
      set(ht4,'fontsize', sfontsize); 
      set(ht5,'fontsize', sfontsize); 
     
    end
    
  end 
  
end